/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: CanOpenApm_Public.h $
   Last Modification:
    $Author: phuong $
    $Modtime: 1.10.08 14:27 $
    $Revision: 4607 $
   
   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes
 
   Description:
     
    CanOpen Apm
    public
   
   Changes:
 
     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
     4          30.11.12    ES
        PDO counter req/cnf

     3          01.10.08    ES
        Removed unused structures

     2          16.04.07    Eric
        Added Warmstart confirmation data 

     1          13.04.07    Eric
        Created     
     
        
**************************************************************************************/
/**
 * @file CanOpenApm_Public.h
 *  CanOpen Apm - public definition of task
 *
 * The header contains the public definition of task.
 * It has to be included by another task to get access of task specfic definition.
 * 
 * @note
 * The structures for the services must be packed on 1 byte of boundary.
 * The <code>#pragma</code> instructions are already planned for Microsoft compiler.
 * For gnu's compiler and Realview compiler the macros <code>__PACKED_PRE</code>
 * and <code>__PACKED_PRE</code> have to be added with the structural definition
 * in addition.
 */
#ifndef __CANOPEN_APM_PUBLIC_H
#define __CANOPEN_APM_PUBLIC_H


/*************************************************************************************/
/** @name Queue Name
 *
 * Use the queue name to identify the process queue of task 'CanOpen Apm'.
 * Example for internal identification:<br>
 * @code
 * TLR_RESULT eRslt;
 * TLR_HANDLE hQue;
 * TLR_UINT   uiInstance = 0;
 * 
 * eRslt = TLR_QUE_IDENTIFY_INTERN(
 *                                 CANOPEN_APM_QUEUE_NAME,
 *                                 uiInstance,
 *                                 &hQue
 *                                );
 * @endcode
 * <br>
 * Example for external or normal identification:<br>
 * @code
 * TLR_RESULT      eRslt;
 * TLR_QUE_LINK_T  tQue;
 * TLR_UINT        uiInstance = 0;
 * 
 * eRslt = TLR_QUE_IDENTIFY(CANOPEN_APM_QUEUE_NAME, uiInstance, &tQue);
 * @endcode
 * <br>
 * @{
 */
/** queue name */
#define CANOPEN_APM_QUEUE_NAME        "QUE_CANOPENAPM"

/** @} */

/*-----------------------------------------------------------------------------------*/
/*------------------- General definitions -------------------------------------------*/
/*-----------------------------------------------------------------------------------*/
#define CANOPEN_APM_MAX_NODES            128  /* maximum number of nodes             */

#define CANOPEN_APM_WD_OFF            0x0000
#define CANOPEN_APM_WD_MIN_TIMEOUT    0x0014
#define CANOPEN_APM_WD_MAX_TIMEOUT    0xFFFF

#define CANOPEN_APM_GET_STATE_REQ                   0x00003A00L
#define CANOPEN_APM_GET_STATE_CNF                   0x00003A01L

#define CANOPEN_APM_WARMSTART_REQ                   0x00003A02L
#define CANOPEN_APM_WARMSTART_CNF                   0x00003A03L

#define CANOPEN_APM_ENABLE_DISABLE_PDO_COUNTER_REQ  0x00003A04L
#define CANOPEN_APM_ENABLE_DISABLE_PDO_COUNTER_CNF  0x00003A05L

/*************************************************************************************/
/* packets */

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(__CANOPEN_APM_PUBLIC)
#endif


/** @name Packet Data Definition
 *
 * The following defined structures represent the specific parameter
 * of the several services, which are supported by the task. 
 * @{
 */

/*************************************************************************************/
/** type of <code>CANOPEN_APM_GET_STATE_CNF_DATA_Ttag</code> */
typedef struct CANOPEN_APM_GET_STATE_CNF_DATA_Ttag
  CANOPEN_APM_GET_STATE_CNF_DATA_T;

/** Get state confirmation data
 *
 * The structure represent the specific confirmation parameter of the service.
 */

__PACKED_PRE struct CANOPEN_APM_GET_STATE_CNF_DATA_Ttag  /* Get state confirmation data */
{
  TLR_UINT32 ulHighestMappedSendBufferNum;
  TLR_UINT32 ulHighestMappedRecvBufferNum;

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_APM_WARMSTART_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_APM_WARMSTART_REQ_DATA_Ttag
  CANOPEN_APM_WARMSTART_REQ_DATA_T;

/** type of <code>CANOPEN_APM_WARMSTART_CNF_DATA_Ttag</code> */
typedef struct CANOPEN_APM_WARMSTART_CNF_DATA_Ttag
  CANOPEN_APM_WARMSTART_CNF_DATA_T;
 
#define CANOPEN_APM_SYS_FLAG_COM_CONTROLLED_RELEASE   0x00000001L

__PACKED_PRE struct CANOPEN_APM_WARMSTART_REQ_DATA_Ttag  /* Warmstart request data */
{
  TLR_UINT32  ulSystemFlags;    /* System flags                     */
  TLR_UINT32  ulWdgTime;        /* Watchdog time                    */  
  TLR_UINT32  aulReserved[7];   /* Reserved for further use         */

}__PACKED_POST;


__PACKED_PRE struct CANOPEN_APM_WARMSTART_CNF_DATA_Ttag  /* Warmstart confirmation data */
{
  TLR_UINT32  ulSystemFlags;    /* System flags                     */
  TLR_UINT32  ulWdgTime;        /* Watchdog time                    */  
  TLR_UINT32  aulReserved[7];   /* Reserved for further use         */

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_APM_ENABLE_DISABLE_PDO_COUNTER_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_APM_ENABLE_DISABLE_PDO_COUNTER_REQ_DATA_Ttag
  CANOPEN_APM_ENABLE_DISABLE_PDO_COUNTER_REQ_DATA_T;

/** type of <code>CANOPEN_APM_ENABLE_DISABLE_PDO_COUNTER_CNF_DATA_Ttag</code> */
typedef struct CANOPEN_APM_ENABLE_DISABLE_PDO_COUNTER_CNF_DATA_Ttag
  CANOPEN_APM_ENABLE_DISABLE_PDO_COUNTER_CNF_DATA_T;

#define CANOPEN_APM_DISABLE_PDO_COUNTER 0x00000000L
#define CANOPEN_APM_ENABLE_PDO_COUNTER  0x00000001L

__PACKED_PRE struct CANOPEN_APM_ENABLE_DISABLE_PDO_COUNTER_REQ_DATA_Ttag
{
  TLR_UINT32  ulMode;

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_APM_ENABLE_DISABLE_PDO_COUNTER_CNF_DATA_Ttag
{
  TLR_UINT32  ulMode;
  TLR_UINT32  ulDpmOffset;
}__PACKED_POST;

/** @} */


/** @name Packet Definition
 *
 * The following definied structures represent the packets of the several services,
 * which are supported by the task.
 * @{
 */

/*************************************************************************************/
/** type of <code>CANOPEN_APM_PCK_GET_STATE_REQ_Ttag</code> */
typedef struct CANOPEN_APM_PCK_GET_STATE_REQ_Ttag
  CANOPEN_APM_PCK_GET_STATE_REQ_T;

/** type of <code>CANOPEN_APM_PCK_GET_STATE_CNF_Ttag</code> */
typedef struct CANOPEN_APM_PCK_GET_STATE_CNF_Ttag
  CANOPEN_APM_PCK_GET_STATE_CNF_T;

/** Get state request
 *
 * The structure defines the request packet of the service.
 */

__PACKED_PRE struct CANOPEN_APM_PCK_GET_STATE_REQ_Ttag   /* Get state request */
{
  TLR_PACKET_HEADER_T tHead;  /** packet header */

}__PACKED_POST;

/** Get state confirmation
 *
 * The structure defines the confirmation packet of the service.
 */
__PACKED_PRE struct CANOPEN_APM_PCK_GET_STATE_CNF_Ttag   /* Get state confirmation */
{ 
  TLR_PACKET_HEADER_T               tHead;  /** packet header */ 
  CANOPEN_APM_GET_STATE_CNF_DATA_T  tData;  /** packet data   */

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_APM_PCK_WARMSTART_REQ_Ttag</code> */
typedef struct CANOPEN_APM_PCK_WARMSTART_REQ_Ttag
  CANOPEN_APM_PCK_WARMSTART_REQ_T;

/** type of <code>CANOPEN_APM_PCK_WARMSTART_CNF_Ttag</code> */
typedef struct CANOPEN_APM_PCK_WARMSTART_CNF_Ttag
  CANOPEN_APM_PCK_WARMSTART_CNF_T;

__PACKED_PRE struct CANOPEN_APM_PCK_WARMSTART_REQ_Ttag   /* Warmstart request */
{  
  TLR_PACKET_HEADER_T               tHead;  /** packet header */ 
  CANOPEN_APM_WARMSTART_REQ_DATA_T  tData;  /** packet data   */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_APM_PCK_WARMSTART_CNF_Ttag   /* Warmstart confirmation */
{
  TLR_PACKET_HEADER_T               tHead;  /** packet header */
  CANOPEN_APM_WARMSTART_CNF_DATA_T  tData;  /** packet data   */

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_APM_PCK_ENABLE_DISABLE_PDO_COUNTER_REQ_Ttag</code> */
typedef struct CANOPEN_APM_PCK_ENABLE_DISABLE_PDO_COUNTER_REQ_Ttag
  CANOPEN_APM_PCK_ENABLE_DISABLE_PDO_COUNTER_REQ_T;

/** type of <code>CANOPEN_APM_PCK_ENABLE_DISABLE_PDO_COUNTER_CNF_Ttag</code> */
typedef struct CANOPEN_APM_PCK_ENABLE_DISABLE_PDO_COUNTER_CNF_Ttag
  CANOPEN_APM_PCK_ENABLE_DISABLE_PDO_COUNTER_CNF_T;

__PACKED_PRE struct CANOPEN_APM_PCK_ENABLE_DISABLE_PDO_COUNTER_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                tHead;  /** packet header */
  CANOPEN_APM_ENABLE_DISABLE_PDO_COUNTER_REQ_DATA_T  tData;  /** packet data   */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_APM_PCK_ENABLE_DISABLE_PDO_COUNTER_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                tHead;  /** packet header */
  CANOPEN_APM_ENABLE_DISABLE_PDO_COUNTER_CNF_DATA_T  tData;  /** packet data   */

}__PACKED_POST;

/** @} */

/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(__CANOPEN_APM_PUBLIC)
#endif


/*************************************************************************************/
#endif /* #ifndef __CANOPEN_APM_PUBLIC_H */

/**************************************************************************************/
/*------------------------------------------------------------------------------------*/
/*-----------------------------EOF----------------------------------------------------*/
/*------------------------------------------------------------------------------------*/
/**************************************************************************************/
